<?php

namespace Import\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * SessionCurrency
 *
 * @ORM\Table(name="currency_sessions")
 * @ORM\Entity(repositoryClass="Import\ApiBundle\Repository\SessionCurrencyRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class SessionCurrency
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="currencyId", type="integer")
     */
    private $currencyId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date", type="datetime")
     */
    private $date;

    /**
     * @var float
     *
     * @ORM\Column(name="open", type="float")
     */
    private $open;

    /**
     * @var float
     *
     * @ORM\Column(name="high", type="float")
     */
    private $high;

    /**
     * @var float
     *
     * @ORM\Column(name="low", type="float")
     */
    private $low;

    /**
     * @var float
     *
     * @ORM\Column(name="close", type="float")
     */
    private $close;

    /**
     * @var float
     *
     * @ORM\Column(name="volume", type="float")
     */
    private $volume;

    /**
     * @var float
     *
     * @ORM\Column(name="oi", type="float")
     */
    private $oi;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="createAt", type="datetime")
     */
    private $createAt;

    /**
     * @ORM\ManyToOne(targetEntity="Currency",inversedBy="sessions")
     * @ORM\JoinColumn(name="currencyId", referencedColumnName="id")
     */
    private $currency;

    /**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->createAt = new \DateTime();
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set currencyId
     *
     * @param integer $currencyId
     * @return SessionCurrency
     */
    public function setCurrencyId($currencyId)
    {
        $this->currencyId = $currencyId;
    
        return $this;
    }

    /**
     * Get currencyId
     *
     * @return integer 
     */
    public function getCurrencyId()
    {
        return $this->currencyId;
    }

    /**
     * Set date
     *
     * @param \DateTime $date
     * @return SessionCurrency
     */
    public function setDate($date)
    {
        $this->date = $date;
    
        return $this;
    }

    /**
     * Get date
     *
     * @return \DateTime 
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * Set open
     *
     * @param float $open
     * @return SessionCurrency
     */
    public function setOpen($open)
    {
        $this->open = $open;
    
        return $this;
    }

    /**
     * Get open
     *
     * @return float 
     */
    public function getOpen()
    {
        return $this->open;
    }

    /**
     * Set high
     *
     * @param float $high
     * @return SessionCurrency
     */
    public function setHigh($high)
    {
        $this->high = $high;
    
        return $this;
    }

    /**
     * Get high
     *
     * @return float 
     */
    public function getHigh()
    {
        return $this->high;
    }

    /**
     * Set low
     *
     * @param float $low
     * @return SessionCurrency
     */
    public function setLow($low)
    {
        $this->low = $low;
    
        return $this;
    }

    /**
     * Get low
     *
     * @return float 
     */
    public function getLow()
    {
        return $this->low;
    }

    /**
     * Set close
     *
     * @param float $close
     * @return SessionCurrency
     */
    public function setClose($close)
    {
        $this->close = $close;
    
        return $this;
    }

    /**
     * Get close
     *
     * @return float 
     */
    public function getClose()
    {
        return $this->close;
    }

    /**
     * Set volume
     *
     * @param float $volume
     * @return SessionCurrency
     */
    public function setVolume($volume)
    {
        $this->volume = $volume;
    
        return $this;
    }

    /**
     * Get volume
     *
     * @return float 
     */
    public function getVolume()
    {
        return $this->volume;
    }

    /**
     * Set oi
     *
     * @param float $oi
     * @return SessionCurrency
     */
    public function setOi($oi)
    {
        $this->oi = $oi;
    
        return $this;
    }

    /**
     * Get oi
     *
     * @return float 
     */
    public function getOi()
    {
        return $this->oi;
    }

    /**
     * Set createAt
     *
     * @param \DateTime $createAt
     * @return SessionCurrency
     */
    public function setCreateAt($createAt)
    {
        $this->createAt = $createAt;
    
        return $this;
    }

    /**
     * Get createAt
     *
     * @return \DateTime 
     */
    public function getCreateAt()
    {
        return $this->createAt;
    }

    /**
     * Set currency
     *
     * @param \Import\ApiBundle\Entity\Currency $currency
     * @return SessionCurrency
     */
    public function setCurrency(\Import\ApiBundle\Entity\Currency $currency = null)
    {
        $this->currency = $currency;
    
        return $this;
    }

    /**
     * Get currency
     *
     * @return \Import\ApiBundle\Entity\Currency 
     */
    public function getCurrency()
    {
        return $this->currency;
    }
}